/**
* Script: game_engine.js
* Written by: Radnen
* Updated: 1/16/2011
**/

RequireScript("engine/namegen.js");
RequireScript("engine/gamehud.js");
RequireScript("engine/quests.js");
RequireScript("engine/stat.js");
RequireScript("engine/bullets.js");
RequireScript("engine/items.js");
RequireScript("engine/camera.js");
RequireScript("engine/ship.js");
RequireScript("engine/player.js");
RequireScript("engine/planets.js");
RequireScript("engine/asteroids.js");
RequireScript("engine/starchart.js");
RequireScript("engine/game_worlds.js");
RequireScript("engine/particle_engine.js");
RequireScript("engine/enemy.js");

var Genesis = ({
	player: null,
	ships: [],
	bullets: [],
	planets: [],
	stars: [],
	asteroids: [],
	battlers: 0,
	useMouse: false,
	starQuality: true,
	
	addBattler: function() {
		if (this.battlers == 0) {
			Audio.changeMusic(Resources.music.discovery);
		}
		this.battlers++;
	},
	
	removeBattler: function() {
		this.battlers--;
		if (this.battlers == 0) {
			Audio.changeMusic(Resources.music.abyss);
		}
	},
		
	updatePlanets: function() {
		var i = this.planets.length;
		while(i--) Planets[this.planets[i]].update();
	},
	
	createBullet: function(bullet) {
		this.bullets.push(bullet);
	},
	
	// generate stars //
	generateStars: function() {
		var i = 50;
		while(i--) {
			var star = new Star(Math.random()*SW, Math.random()*SH);
			star.speed = Math.ceil(Math.random()*6)/7;
			this.stars.push(star);
		}
	},
	
	// generate asteroids //
	generateAsteroids: function(world) {
		var i = world.asteroidDensity;
		while(i--) {
			var asteroid = new Asteroid(-5000+(Math.random()*10000), -5000+(Math.random()*10000));
			this.asteroids.push(asteroid);
		} 
	},
		
	// update existing world //
	updateGameWorld: function() {
		Resources.images[GameWorlds[this.currentWorld].nebula].blit(Camera.x/10, Camera.y/10);
		Utility.call(this.stars, "update");
		
		GameHud.updateHighlight();
		this.generateShips();
		
		if (Cursor.onLeftClick()) {
			Utility.call(this.ships, "checkMouse");
		}
		this.updatePlanets();
		GameHud.renderBraces();
		Utility.call(this.asteroids, "update");
		Utility.call(this.ships, "update");
		Utility.call(this.bullets, "update");
		Audio.update();
		this.player.ship.update();
		ParticleEngine.updateParticles();
		GameHud.drawGUI();
		
		while(AreKeysLeft()) {
			switch (GetKey()) {
				case KEY_TAB: GameHud.showChart = !GameHud.showChart; break;
				case KEY_M: GameHud.showMinimap = !GameHud.showMinimap; break;
				case KEY_Q: var qstate = new QuestState().show; break;
				case KEY_MINUS: if (GameHud.range < 25) GameHud.range++; break;
				case KEY_EQUALS: if (GameHud.range > 1) GameHud.range--; break;
				case KEY_ESCAPE: gamemenu.show(); break;
				case KEY_I: var istate = new InventoryState().show(); break;
				case KEY_1: this.player.ship.setupShip(Ships[0]); break;
				case KEY_2: this.player.ship.setupShip(Ships[1]); break;
				case KEY_3: this.player.ship.setupShip(Ships[2]); break;
				case KEY_4: this.player.ship.setupShip(Ships[3]); break;
				case KEY_5: this.player.ship.setupShip(Ships[4]); break;
				case KEY_6: this.player.ship.setupShip(Ships[5]); break;
				case KEY_7: this.player.ship.setupShip(Ships[6]); break;
				case KEY_F1: ShowHelp(); break;
			}
		}
	},
		
	// Load a new world //
	loadGameWorld: function(world, initial) {
		world = GameWorlds[world];
		this.ids = 0;
		if (!initial && this.battlers > 0) {
			this.battlers = 1;
			this.removeBattler();
		}
		this.currentWorld = world.name;
		this.purgeGameWorld();
		this.generateStars();
		this.generateAsteroids(world);
		this.planets = world.planets;
		for (var i = 0; i < this.planets.length; ++i) {
			Planets[this.planets[i]].generateQuests();
		}
		Genesis.player.addBountyShips();
		StarChart.ox = world.origin.x;
		StarChart.oy = world.origin.y;
		this.addRandomShip();
	},
	
	ids: 0,
	addRandomShip: function() {
		var ship = CreateRandomShip();
		if (Utility.random(9) >= 5)
			ship.x = -3000+Utility.random(1000);
		else ship.x = 2000+Utility.random(1000);
		if (Utility.random(9) >= 5)
			ship.y = -3000+Utility.random(1000);
		else ship.y = 2000+Utility.random(1000);
		ship.id = this.ids;
		this.ids++;
		this.ships.push(ship);
	},
	
	t_ship: 0,
	t_ship_msecs: 2000,
	generateShips: function() {
		if (this.t_ship == 0) this.t_ship = GetTime();
		if (this.t_ship + this.t_ship_msecs < GetTime()) {
			if (this.ships.length < GameWorlds[this.currentWorld].shipcap) {
				this.addRandomShip();
				this.t_ship_msecs = 2000+Utility.random(1000);
			}
			this.t_ship = 0;
		}
	},
	
	// Get Rid of the Current in World Data //
	purgeGameWorld: function() {
		GameHud.unsetPlanet();
		this.stars = [];
		this.ships = [];
		this.planets = [];
		this.bullets = [];
		this.asteroids = [];
	},
	
	save: function(filename) {
		var File = OpenFile(filename + ".sav");
		this.player.save(File);
		File.write("World", this.currentWorld);
		File.write("CamX", Camera.x);
		File.write("CamY", Camera.y);
		File.flush();
		File.close();
	},
	
	load: function(filename) {
		this.purgeGameWorld();
		var File = OpenFile(filename + ".sav");
		if (!this.player) this.player = new Player();
		this.player.load(File);
		this.loadGameWorld(File.read("World", "Sol"), true);
		Camera.x = File.read("CamX", 0);
		Camera.y = File.read("CamY", 0);
		Genesis.player.ship.x -= Camera.x;
		Genesis.player.ship.y -= Camera.y;
		File.close();
	},
	
	saveOptions: function() {
		var file = OpenFile("../options.ini");
		file.write("Music_Volume", Audio.max);
		file.write("Sound_Volume", Audio.smax);
		file.write("Star_Quality", this.starQuality);
		file.flush();
		file.close();
	},
	
	loadOptions: function() {
		var file = OpenFile("../options.ini");
		Audio.max = file.read("Music_Volume", 200);
		Audio.smax = file.read("Sound_Volume", 220);
		this.starQuality = file.read("Star_Quality", true);
		file.close();
	}
})

function Star(x, y)
{
	this.image = Resources.images.star;
	this.x = x;
	this.y = y;
	this.color = CreateColor(155+Math.floor(Math.random()*100), 200+Math.floor(Math.random()*55), 155+Math.floor(Math.random()*100));
	this.speed = 0;
}

Star.prototype.update = function()
{
	if (Genesis.starQuality)
		this.image.blitMask(this.x, this.y, this.color);
	else
		Point(this.x, this.y, this.color);
	this.x -= Genesis.player.ship.vx*this.speed;
	this.y -= Genesis.player.ship.vy*this.speed;
	if (this.y > SH) this.y = 0;
	if (this.y < 0) this.y = SH;
	if (this.x > SW) this.x = 0;
	if (this.x < 0) this.x = SW;
}